#include "firefly.h"


firefly_t fireflies[30];                            // 30 fireflies
uint8_t   ocr_data[6];                              // OCR0A and DDRB datas for Timer0 Compare Match ISR, computed PWM Dutycycles
uint16_t  hungry_threshold;                         // threshold for lightning fireflies

// 12 fixed registers assigned to speedup ISRs, Timer0 Overflow and Output Compare
register uint16_t  _saveZ    asm("r2");             // save Z register
register uint16_t  _saveY    asm("r4");             // save Y register
register uint8_t   _saveSREG asm("r6");             // save SREG
register uint8_t   _zero     asm("r7");             // zero Register
register uint8_t*  _ocr_ptr  asm("r8");             // pointer to current ocr_data[] entry
register firefly_p _fly_ptr  asm("r10");            // pointer to current firefly[] entry
register uint8_t   _ddr_idx  asm("r16");            // index into ddr_data[] entry, 0 upto 15 in +4 steps
register uint8_t   flags     asm("r17");


static void init(void) {
  // init global registers
    _fly_ptr = (firefly_p)&fireflies;
    _zero    = 0;
    _ddr_idx = 0;
    flags    = 0;
  // enable watchdog ISR
    wdt_reset();
    WDTCSR |= (1 << WDE) | (1 << WDCE);   //dem tiny44-WDTCSR scheint das tiny45-WDTCR 
    WDTCSR  = (1 << WDIE);				   // zu entsprechen
  // Port
    PORTB  = 0;
    DDRB   = 0;
  // Power Reduction, enable ADC for setup
    PRR    = (1 << PRTIM1) | (1 << PRTIM0) | (1 << PRUSI);
  //  AC/ADC
    ACSR   = (1 << ACD);
    ADCSRA = 0;
    ADCSRB = 0;
//tiny45:    DIDR0  = (1 << ADC0D) | (1 << ADC2D) | (1 << ADC3D) | (1 << AIN1D) | (1 << AIN0D);
//tiny44:
    DIDR0  = (1 << ADC0D);  // analoges Signal am ADC 0
  // Power Reduction, enable Timer0
    PRR    = (1 << PRTIM1) | (1 << PRUSI) | (1 << PRADC);
  // Pin Change Mask on PB2, for calling Bootloader
//    GIMSK  = 0;   // interrunps aus?!? (ist so auch in der orig-SOurce)
	
// tiny45:    PCMSK  = (1 << PCINT2);
// tiny44: Bootload an PB2=pin change interrupt #10
// PCMSK1  = 0;  // Pin Change Interrupt deaktivieren    war: (1 << PCINT10);
  // Timer0, Overflow & Compare Match ISR used
    TCCR0A = 0;
    TCCR0B = 0;
    OCR0A  = 0;
    TCNT0  = 0;
    //tiny45: TIMSK  = (1 << OCIE0A) | (1 << TOIE0);
	//tiny44:
	TIMSK0  = (1 << OCIE0A) | (1 << TOIE0);
	
    //tiny45: TIFR   = (1 << OCF0A) | (1 << TOV0);
	//tiny44:
	TIFR0   = (1 << OCF0A) | (1 << TOV0);
	
  // init PRNG, load last seed from EEPROM, calculate next seed and store back to EEPROM, use another polynom as in lfsr()
    eeprom_read_block((uint8_t *)&seed, (uint8_t *)(0), 4);
    lfsr_poly(32, 0x8140C9D5);
    eeprom_write_block((uint8_t *)&seed, (uint8_t *)(0), 4);
}

static uint16_t update_fireflies(void) {

  // update waves
    firefly_p fly = (firefly_p)&fireflies;
    firefly_p cur;
    for (uint8_t i = 30; i > 0; i--) {
      if ((fly->wave_ptr == 0) && (fly->hungry == 0)) {
        uint16_t* data = (uint16_t*)&wave_data[lfsr(5)];                // choose wave for lightning from a set of 32 waves randomly
        cur = fly;
        uint16_t ptr = pgm_read_word_inc(data);
        cur->wave_end = pgm_read_word_inc(data);
        cli();
        cur->wave_ptr = ptr;
        flags |= FLAG_TIMER;
        sei();                                                          // update next energy points, each neighbor fly becomes half of energy points
        uint16_t energy = pgm_read_word_inc(data);
        while (energy > 0) {
          cur->energy += energy;
          if (++cur >= &fireflies[30]) cur = (firefly_p)&fireflies;
          energy /= 2;
        }
      }
      fly++;
    }
  // calc feeding step and update fireflies hungry value
    uint16_t food = 0xFFFF;
    uint16_t threshold = hungry_threshold;
    fly = (firefly_p)&fireflies;
    for (uint8_t i = 30; i > 0; i--) {
      uint16_t hungry = fly->hungry;
      if (fly->energy > 0) {
        if ((hungry == 0) || (hungry > threshold)) {
          uint16_t max = 0xFFFF - fly->energy;
          if (hungry < max) hungry += fly->energy;
            else hungry = 0xFFFF;
          if (threshold < 0xFFF0) threshold += 3;
        } else if (threshold > 1) {
          threshold -= 2;
        }
      }
      if (hungry < food) food = hungry;
      fly->hungry = hungry;
      fly->energy = 0;
      fly++;
    }
  // hungry_threshold ensures that fireflies with low hungry is ligthning early and so we get a ligthing in periodic intervals of groups of fireflies,
  // eg. or some longer delays of no lightning dependend on how many energy is consumed by the ligthning waves
    hungry_threshold = threshold;
  // feeding
    fly = (firefly_p)&fireflies;
    for (uint8_t i = 30; i > 0; i--) {
      fly->hungry -= food;
      fly++;
    }
  // return minimal watchdog timer cycles for sleep mode, eg. food
    return food;
}

static void measure_isnight(void) {

   // flags |= FLAG_ISNIGHT;
    flags &= ~FLAG_ISNIGHT;

	// Port PA7 fr die Dauer der Messung auf high-> Spannungsteiler mit LDR aktivieren
//    PORTA  |= (1 << PA7);
//    DDRA   |= (1 << PA7);


  // enable ADC Noise Reduction Sleep Mode
  //  MCUCR  = (1 << SE) | (1 << SM0);      // CPU sleep mode enable, und Mode auf "ADC noise reduction" setzen
  // first dummy reading, VRef=Vcc

  // read battery voltage

 //   uint16_t bat_volt = ADC;
 // read solar panel voltage
	flags |= FLAG_ISNIGHT;
		}
  // disable ADC
//    ADCSRA = 0;
//  PRR    = (1 << PRTIM1) | (1 << PRUSI) | (1 << PRADC);

// PA7 auf Eingang (Spannungsteiler stromlos machen)
 // DDRA  &= ~(1 << PA7);
 //   PORTA &= ~(1 << PA7);   // Pullup ausschalten
// laut Messung ist der Pin fuer ca. 220us auf high





static uint16_t wdt_setup(uint16_t time) {

// Zur Sicherheit: max. Sleeptime
//if (time>MAX_INTERVAL)
//	{
//	time=MAX_INTERVAL;
//	}

  // setup watchdog to next highest timeout that match time
    uint16_t res = 1;
    uint8_t  idx = 1;
    while ((res <= time) && (idx < 10)) {
      res += res;
      idx++;
    }
    res /= 2;
//   if (--idx > 7) idx = (idx & 0x0F) | (1 << WDP3);
    if (--idx > 7) idx = (idx & 0x07) | (1 << WDP3);  // Bugfix
    idx |= (1 << WDIE);                                                 // enable WDT-ISR
    wdt_reset();
    WDTCSR |= (1 << WDE) | (1 << WDCE); //dem tiny44-WDTCSR scheint das tiny45-WDTCR 
    WDTCSR  = idx;                       // zu entsprechen
    return res;
}

int main(void) {

    init();
    sei();

    uint16_t timeout = 0;   // remaining time in WDT cycles a 16ms upto next event
    uint16_t measure = 0;   // remaining time upto next measurement

    while (1) {
    // check for update, FLAG_UPDATE is set in Watchdog ISR
      if (flags & FLAG_UPDATE) {
        flags &= ~FLAG_UPDATE;
        if (timeout == 0) {
          if (flags & FLAG_ISNIGHT) {
            timeout = update_fireflies();
            if (measure <= timeout) {
              measure = MEASURE_INTERVAL;
              flags |= FLAG_MEASURE;
            } else measure -= timeout;
          } else {
            measure = MEASURE_INTERVAL;
            timeout = measure;
            flags |= FLAG_MEASURE;
          }
        }
        timeout -= wdt_setup(timeout);
      }
    // check iff we playing waves
      if (flags & FLAG_TIMER) {
      // enable PWM-Timer0, XTAL / 64
        TCCR0B = (1 << CS01);
		// | (1 << CS00);
      // sleep mode idle
        MCUCR  = (1 << SE);
        sleep_cpu();
      } else {
      // disable Timer0
        TCCR0B = 0;
        OCR0A  = 0;
        TCNT0  = 0;
      // enable deep Power Down Sleep Mode
        MCUCR  = (1 << SE) | (1 << SM1);
      // enable Pin Change for Bootloader on PB2
 //       PORTB  = 0;
 //     DDRB   = 0; 
        cli();
// tiny45:		
//        GIMSK  = (1 << PCIE);
//        GIFR   = (1 << PCIF);
// tiny44:		
//        GIMSK  = (1 << PCIE1);  // PB2 liegt auf dem Pin-Change-Interrupt #1
//        GIFR   = (1 << PCIF1);
// wegen sporadischer Hnger: Pinchange mal deaktivieren
   //   GIMSK  = 0;  // 
   //     GIFR   = 0;
	
	
        sei();
        sleep_cpu();
        GIMSK  = 0;
      // check iff we must measure battery and solar panel
      // if (flags & FLAG_MEASURE) {
    //   flags &= ~FLAG_MEASURE;
          measure_isnight();
        }
      
    }
}



